<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

wp_nonce_field( 'genesis_inpost_scripts_save', 'genesis_inpost_scripts_nonce' );
?>
<table class="form-table">
	<tbody>

	<tr>
		<th scope="row">
			<label for="genesis_scripts"><strong><?php esc_html_e( 'Header Scripts', 'genesis' ); ?></strong></label>
		</th>
		<td>
			<p><textarea class="widefat" rows="4" name="genesis_seo[_genesis_scripts]"
						id="genesis_scripts"><?php echo esc_textarea( genesis_get_custom_field( '_genesis_scripts' ) ); ?></textarea>
			</p>
			<p>
				<?php
				/* translators: %s: Name of head tag. */
				printf( esc_html__( 'Output before the closing %s tag, after sitewide header scripts.', 'genesis' ), genesis_code( 'head' ) );
				?>
			</p>
		</td>
	</tr>

	<tr>
		<th scope="row">
			<label for="genesis_scripts_body"><strong><?php esc_html_e( 'Body Scripts', 'genesis' ); ?></strong></label>
		</th>
		<td>
			<p><textarea class="widefat" rows="4" name="genesis_seo[_genesis_scripts_body]"
						id="genesis_scripts_body"><?php echo esc_textarea( genesis_get_custom_field( '_genesis_scripts_body' ) ); ?></textarea>
			</p>
		</td>
	</tr>

	<tr>
		<th scope="row">
			<label for="genesis_scripts_body_position"><?php esc_html_e( 'Body Scripts Position', 'genesis' ); ?></label>
		</th>
		<td>
			<select name="genesis_seo[_genesis_scripts_body_position]" id="genesis_scripts_body_position">
				<option value="bottom"<?php selected( genesis_get_custom_field( '_genesis_scripts_body_position' ), 'bottom' ); ?>><?php esc_html_e( 'Bottom: before closing body tag', 'genesis' ); ?></option>
				<option value="top"<?php selected( genesis_get_custom_field( '_genesis_scripts_body_position' ), 'top' ); ?>><?php esc_html_e( 'Top: after opening body tag', 'genesis' ); ?></option>
			</select>
		</td>
	</tr>

	</tbody>
</table>
