<?php
/**
 * This file adds the News Page to the Metro Pro Child Theme.
*
 * @author StudioPress
 * @package Generate
 * @subpackage Customizations
 */

/*
Template Name: News
*/

add_action( 'genesis_meta', 'metro_news_genesis_meta' );
/**
 * Add widget support for newspage. If no widgets active, display the default loop.
 *
 */
function metro_news_genesis_meta() {

	if ( is_active_sidebar( 'news-top' ) || is_active_sidebar( 'news-middle-left' ) || is_active_sidebar( 'news-middle-right' ) || is_active_sidebar( 'news-bottom' ) ) {

		// Force content-sidebar layout setting
		add_filter( 'genesis_pre_get_option_site_layout', '__genesis_return_content_sidebar' );

		// Add metro-pro-news body class
		add_filter( 'body_class', 'metro_body_class' );
		function metro_body_class( $classes ) {
   			$classes[] = 'metro-pro-news';
  			return $classes;
		}

		// Remove the default Genesis loop
		remove_action( 'genesis_loop', 'genesis_do_loop' );

		// Add newspage widgets
		add_action( 'genesis_loop', 'metro_newspage_widgets' );

	}
}

function metro_newspage_widgets() {

	genesis_widget_area( 'news-top', array(
		'before'	=> '<div class="news-top widget-area">',
		'after'		=> '</div>',
	) );
	
	if ( is_active_sidebar( 'news-middle-left' ) || is_active_sidebar( 'news-middle-right' ) ) {

		echo '<div class="news-middle">';

		genesis_widget_area( 'news-middle-left', array(
			'before'	=> '<div class="news-middle-left widget-area">',
			'after'		=> '</div>',
		) );

		genesis_widget_area( 'news-middle-right', array(
			'before'	=> '<div class="news-middle-right widget-area">',
			'after'		=> '</div>',
		) );

		echo '</div>';
	
	}

	genesis_widget_area( 'news-bottom', array(
		'before'	=> '<div class="news-bottom widget-area">',
		'after'		=> '</div>',
	) );

}

genesis();